/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.text.AbstractFoldingComputer;
import com.aptana.editor.html.HTMLFoldingComputer;
import com.aptana.editor.php.internal.parser.PHPParseRootNode;
import com.aptana.editor.php.internal.parser.nodes.PHPClassParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPCommentNode;
import com.aptana.editor.php.internal.parser.nodes.PHPFunctionParseNode;
import com.aptana.parsing.ast.IParseNode;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;

public class PHPFoldingComputer
extends AbstractFoldingComputer {
    private boolean hasCachedAST;

    public PHPFoldingComputer(AbstractThemeableEditor editor, IDocument document) {
        super(editor, document);
    }

    public boolean isFoldable(IParseNode child) {
        if ("com.aptana.contenttype.php".equals(child.getLanguage())) {
            if (child instanceof PHPCommentNode) {
                PHPCommentNode commentNode = (PHPCommentNode)child;
                return commentNode.isMultiline() || commentNode.isPHPDoc();
            }
            switch (child.getNodeType()) {
                case 4500: 
                case 4501: 
                case 4509: 
                case 4511: 
                case 4512: 
                case 4513: 
                case 4514: 
                case 4515: 
                case 4516: 
                case 4517: 
                case 4518: {
                    return true;
                }
            }
            return false;
        }
        return this.htmlFoldingComputer().isFoldable(child);
    }

    private synchronized AbstractFoldingComputer htmlFoldingComputer() {
        return new HTMLFoldingComputer(this.getEditor(), this.getDocument());
    }

    public boolean isCollapsed(IParseNode child) {
        if ("com.aptana.contenttype.php".equals(child.getLanguage())) {
            if (child instanceof PHPFunctionParseNode) {
                return Platform.getPreferencesService().getBoolean("com.aptana.editor.php.epl", "foldFunctions", false, null);
            }
            if (child instanceof PHPClassParseNode) {
                return Platform.getPreferencesService().getBoolean("com.aptana.editor.php.epl", "foldClasses", false, null);
            }
            if (child instanceof PHPCommentNode) {
                PHPCommentNode commentNode = (PHPCommentNode)child;
                if (commentNode.isPHPDoc()) {
                    return Platform.getPreferencesService().getBoolean("com.aptana.editor.php.epl", "foldPHPDoc", false, null);
                }
                return Platform.getPreferencesService().getBoolean("com.aptana.editor.php.epl", "foldComments", false, null);
            }
        }
        return this.htmlFoldingComputer().isCollapsed(child);
    }

    protected Map<ProjectionAnnotation, Position> getPositions(IProgressMonitor monitor, IParseNode parseNode) {
        if (parseNode instanceof PHPParseRootNode) {
            this.hasCachedAST = ((PHPParseRootNode)parseNode).isCached();
        }
        return super.getPositions(monitor, parseNode);
    }

    public boolean hasCachedAST() {
        return this.hasCachedAST;
    }
}

